package chess4j.pieces;

import chess4j.Color;
import chess4j.board.directions.East;
import chess4j.board.directions.North;
import chess4j.board.directions.South;
import chess4j.board.directions.West;

public class Rook extends SlidingPiece {

	public static final Rook WHITE_ROOK = new Rook(Color.WHITE);
	public static final Rook BLACK_ROOK = new Rook(Color.BLACK);
	
	private Rook(Color color) {
		super(color);
	}
	
	public String toString() {
		return isWhite()?"R":"r";
	}
	
	@Override
	protected void addDirections() {
		_dirs.add(East.getInstance());
		_dirs.add(West.getInstance());
		_dirs.add(North.getInstance());
		_dirs.add(South.getInstance());
	}

}
